#include <stdio.h>
#include <stdlib.h>

typedef long long ll;

typedef struct {
    ll key1, key2;
} Pair;


int cmp(const void *p1, const void *p2){
    Pair *a = (Pair*)p1;
    Pair *b = (Pair*)p2;
    if(a->key1 != b->key1) return a->key1 < b->key1 ? -1 : 1;
    if(a->key2 != b->key2) return a->key2 < b->key2 ? -1 : 1;
    return 0;
}


ll countPairs(Pair *arr, int n){
    qsort(arr, n, sizeof(Pair), cmp);
    ll res = 0;
    int i = 0;
    while(i < n){
        int j = i+1;
        while(j < n && arr[j].key1 == arr[i].key1 && arr[j].key2 == arr[i].key2) j++;
        ll cnt = j - i;
        res += cnt * (cnt - 1) / 2;
        i = j;
    }
    return res;
}

int main(){
    int n;
    scanf("%d",&n);
    ll *x = malloc(n*sizeof(ll));
    ll *y = malloc(n*sizeof(ll));
    for(int i=0;i<n;i++) scanf("%lld %lld",&x[i],&y[i]);

    Pair *arr = malloc(n*4*sizeof(Pair));
    int idx = 0;

 
    for(int i=0;i<n;i++){
        arr[idx].key1 = y[i];
        arr[idx].key2 = x[i]%2;
        idx++;
    }
    ll res = countPairs(arr, n);

    
    for(int i=0;i<n;i++){
        arr[idx].key1 = x[i];
        arr[idx].key2 = y[i]%2;
        idx++;
    }
    res += countPairs(arr+n, n);

    
    for(int i=0;i<n;i++){
        arr[idx].key1 = x[i]+y[i];
        arr[idx].key2 = (x[i]-y[i])%2;
        idx++;
    }
    res += countPairs(arr+2*n, n);

    
    for(int i=0;i<n;i++){
        arr[idx].key1 = x[i]-y[i];
        arr[idx].key2 = (x[i]+y[i])%2;
        idx++;
    }
    res += countPairs(arr+3*n, n);

    printf("%lld\n", res);

    free(x);
    free(y);
    free(arr);
    return 0;
}